#ifndef ATOMLIST_CLASS
#define ATOMLIST_CLASS

#include <LEDA/basic.h>
#include <LEDA/d_array.h>
#include <LEDA/h_array.h>

template<class E>
class AtomList {
 private:
  int nAtoms;
  h_array<int, E> atomArray(0);
  sortseq<String,int> *atomHash;
  static int tempIndex; /* static cause, this is used as a 
			       storage space in a lookup operation */
 public:
  AtomList();
  ~AtomList(void);

  AtomList *duplicate(AtomList *atomlist);
  AtomList &operator=(const AtomList &atomList);
  inline E& operator[](const String &atomId) 
    {return ((tempIndex = atomHash->inf(atomHash->lookup(atomId)))?
       atomArray[tempIndex]:nil);};
  inline E& operator[](const int &index) 
    {return atomArray[tempIndex];};
  int addAtom(E atom);
  int deleteAtom(const String &atomId);
  int index(const String &atomId);
}



#endif /* ATOMLIST_CLASS */
