#include "junk.h"

void pause( void ) {
  cout << "\nWaiting for <RETURN>\n";
  getchar();
}

// debugging functions
int Print_Polyhedron( Polyhedron &p, char *name = "Polyhedron" ) {
  
  int errors = 0;

  cout << name << " has " << p.nvertices << " vertices :\n";
  for( int v = 0 ; v < p.nvertices ; v++ ) {
    cout <<"\tVertex " << v << " : " << p.vertices[v] << '\n';
  }
    
  cout << '\n' << name << " has " << p.nfaces << " faces :\n";
  for( int f = 0 ; f < p.nfaces ; f++ ) {
    cout << "\tFace " << f << " has " << p.faces[f].npts << " pts : ";
    for( int i = 0 ; i < p.faces[f].npts ; i++ ) {
      cout << p.faces[f].indices[i];
      if( p.faces[f].indices[i] > p.nvertices ) {
	cout << "(ERROR) ";
	errors++;
      } else
	cout << ' ';
    }
    cout << '\n';
  }

  cout << errors << " errors.\n\n";
  return errors;
}
