/* ga_nnet.h */

#ifndef GA_NNET__H
#define GA_NNET__H

#include "ga_iface.h"
#include "ga_input.h"
#include "SysFullNNetwork.hh"

class IdentityNNetwork;

class ga_nnet : public ga {
private:
  bool CopyParametersToNetwork( const StdBitString & );
  void CopyNetworkToParameters( StdBitString & ) const;
  double xform( const StdBitString &, int ) const;
  void WriteBits( StdBitString &, int, double ) const;

protected:
  //SysFullNNetwork *nNet;
  IdentityNNetwork *nNet;

  int nInput;
  int nOutput;
  int nHidden;
  int nNodes;
  double tau;

  SysNodeType act_fn;

  bool init( void );
  bool run( void );
  bool finish( void );
  bool output( void );

  void cleanup( void );

  /* Performance Stuff */
  /* Evaluate the performance */
  double Evaluate( const StdBitString &bstring );
  /* returns performance of simulation */
  double Simulate( void );
  double Step( double stepSize );
  void Reset( void );

  list<ga_real_input *> inputs;
  list<ga_real_input *> outputs;

  double xform_Min, xform_Max, xform_Div;
  int xform_nBits;

  /* file to output state to */
  ofstream *outfile;

public:
  ga_nnet( void );
  ~ga_nnet( void );

  bool set_nHidden( int );
  bool set_act_fn( SysNodeType );
  bool set_xForm( double n, double x, int b );
  bool set_tau( double );

  string type_string( void ) const { return string( "ga nnet" ); }

  int get_nNodes( void ) const;

  bool add_input( ga_real_input & );
  bool add_output( ga_real_input & );

  void clear_inputs( void );
  void clear_outputs( void );

  double SimulateBest( void ); /* virtual from ga */
};

const double cgBiasMap = 5;
const double cgInScaleMap = 5;
const double cgWeightMap =  1./8.;

#endif

