/* display.h */

#ifndef DISPLAY__H
#define DISPLAY__H

#include "common.h"

#ifdef DC_TRACING_ON
#include <LEDA/set.h>
#include "tag.h"
#endif

/* 0 - name and value, 1 - formulae & values, 2 - sets iterated */
extern int disp_verbose;

/* if true, element references and function calls will be replaced with actual
   value */
extern bool disp_substitute;

/* if true, element and function calls will be displayed with the label used for
   hashing rather than their full label */
extern bool disp_as_parsed;

void tab_in( void );



/* set of tags for whom any change in value will be monitored */
#ifdef DC_TRACING_ON
extern set<tag> monitored;

/* returns true if label is monitored, and prints the label info
   depending on disp_verbose level */
bool check_monitored( const dc_label *, cstring );
#else
inline bool check_monitored( const dc_label *, cstring ) { return false; }
#endif

#endif
