/* default.h */

#ifndef DEFAULT__H
#define DEFAULT__H

#include "element.h"

/* all defaults will have a name preceded by default_prefix */
const char *const default_prefix = "_DEFAULT_";

class dc_default : public dc_element {
protected:
  dc_default( void ) {}

public:
  dc_default( cstring label, dc_component *parent );
};

/* default value for a united type. */
class dc_udefault : public dc_default {
protected:
  double coefficient;

  dc_udefault( void ) {}

public:
  dc_udefault( cstring label, dc_component *parent );
  
  void set_coefficient( double c ) { coefficient = c; }
  double get_coefficient( void ) const { return coefficient; }
};

#endif
