/* cor_pipe.h */

#ifndef COR_PIPE__H
#define COR_PIPE__H

#include "pipe.h"
#include "cor_syn_iface.h"

/* - dc_cor_pipe is a descendant of dc_pipe with a point and a shape associated 
   with it.
   - the point is needed top be able to query velocity/force/position of a point on 
   a body even though this feature is not yet in the parser. */
class dc_cor_pipe : public dc_pipe {
private:
  triple loc;
  dc_shape *shape; /* not owned by dc_cor_pipe, so not deleted */
public:
  /* if constructor is called with an invalid type then type will be undef_t */
  dc_cor_pipe( cpipe_type cpt, cstring label, dc_component *parent );

  triple get_loc( void ) const { return loc; }
  void set_loc( const triple &L ) { loc = L; }

  dc_shape *get_shape( void ) { return shape; }
  RigidBody *get_rbody( void ) { return shape ? shape->get_rbody(): nil; }

  int rehash( dep_list & ); /* virtual from dc_element */
};

#endif
