/*******************************************************************************
+
+  LEDA 3.5
+
+  windef.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/

#ifndef LEDA_DOSWIN_H
#define LEDA_DOSWIN_H

#include <LEDA/impl/x_basic.h>

#include <stdlib.h>
#include <string.h>
#include <math.h>

typedef int Window;

struct vga_window
{
  unsigned char* buf;

  int   buf_w;
  int   buf_h;
  int   width;
  int   height;
  int   xpos;
  int   ypos;
  int   x0;
  int   y0;
  int   x1;
  int   y1;
  int   save_xpos;
  int   save_ypos;
  int   save_x0;
  int   save_y0;
  int   save_x1;
  int   save_y1;

  int   clip_x;
  int   clip_y;
  int   clip_x1;
  int   clip_y1;

  int          COLOR;
  int          LINEWIDTH;
  line_style   LINESTYLE;
  drawing_mode MODE;
  text_mode    TEXTMODE;
  int          FONT_WIDTH;
  int          FONT_HEIGHT;

  int   bg_col;
  int   save_bg_col;
  int   label_col;
  char  header[128];
  char  label[128];
  char  iconized;

  Window  id;
  void* inf;
  int   mapped;
  void  (*redraw)(void*);
};

typedef vga_window* VgaWindow;


extern VgaWindow win_list[16];
extern VgaWindow win_stack[16];
extern int win_count;
extern int win_top;

VgaWindow set_draw_window(Window w);

#endif
