/*******************************************************************************
+
+  LEDA 3.5
+
+  misc.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/

bool Is_Simple_Polygon(const list<POINT>& L)
{
  list<SEGMENT> seg_list; 

  list_item it;
  forall_items(it,L)
  { POINT p = L[it];
    POINT q = L[L.cyclic_succ(it)];
    seg_list.append(SEGMENT(p,q));
   }

  GRAPH<POINT,SEGMENT> G;

  SWEEP_SEGMENTS(seg_list,G);

  node v;
  forall_nodes(v,G)
    if (G.degree(v) != 2) return false;

  return true;

}
 
 

