/*******************************************************************************
+
+  LEDA 3.5
+
+  _f_voro_old.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#define NO_RAT_ALGORITHMS
#include <LEDA/plane_alg.h>

// old style voronoi diagrams (for backward compatibility)

void VORONOI(const list<point>& L, double R, GRAPH<point,point>& VD)
{
  GRAPH<circle,point> VD0;

  VORONOI(L,VD0);

  node_array<node> corr(VD0);

  node v;
  forall_nodes(v,VD0)
  { circle C = VD0[v];
    point c;
    if (C.orientation() != 0)
      c = C.center();
    else
    { point a = C.point1();
      point b = C.point3();
      vector v = (b-a).rotate90();
      c = center(a,b) + R*v.norm();
     }
    corr[v] = VD.new_node(c);
   }

  forall_nodes(v,VD0)
  { edge e;
    forall_adj_edges(e,v)
    { node x = corr[v];
      node y = corr[target(e)];
      VD.new_edge(x,y,VD0[e]);
     }
   }
}

