/*******************************************************************************
+
+  LEDA 3.5
+
+  _point_set.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <LEDA/point_set.h>

list<point> Point_Set::all_points()
{ list<point> result;
  list<ps_item> Li = all_items();
  ps_item it;
  forall(it,Li) result.append(point(key1(it),key2(it)));
  return result;
}


ps_item Point_Set::nearest_neighbor(double x, double y)
{
  double  mdist2 = MAXDOUBLE;
  ps_item min_it = nil;

  list<ps_item> Li = all_items();

  ps_item it;
  forall(it,Li)
  { double dx = x - key1(it);
    double dy = y - key2(it);
    double D  = dx*dx + dy*dy;

    if (mdist2 > D)
    { mdist2 = D;
      min_it = it;
     }
   }

   return min_it;
}

