/*******************************************************************************
+
+  LEDA 3.5
+
+  _planar_map.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <LEDA/planar_map.h>


void planar_map::init_face_entries() const
{ face f;
  forall_faces(f,*this) init_face_entry(f->data[0]);
 }

void planar_map::copy_face_entries() const
{ face f;
  forall_faces(f,*this) copy_face_entry(f->data[0]);
 }

void planar_map::clear_face_entries() const
{ face f;
  forall_faces(f,*this) clear_face_entry(f->data[0]);
 }



node planar_map::new_node(const list<edge>& el)
{
  if (el.length() < 2)
      error_handler(1,"planar_map::new_node(el,i):  el.length() < 2."); 

  list_item it = el.first();

  edge e0 = el[it];

  it = el.succ(it);

  face f = adj_face(e0);

  edge e;
  forall(e,el)
  { if (adj_face(e) != f)
      error_handler(1,"planar_map::new_node: edges bound different faces."); 
   }

  e = el[it];

  it = el.succ(it);

  GenPtr face_inf = f->data[0];
  copy_face_entry(face_inf);

  edge x = new_edge(e0,e);
  face fx = adj_face(reversal(x));
  clear_face_entry(fx->data[0]);
  fx->data[0] = face_inf;

  edge e1 = split_edge(x);

  while(it)
  { copy_face_entry(face_inf);
    e1 = new_edge(e1,el[it]);
    face fx = adj_face(reversal(e1));
    clear_face_entry(fx->data[0]);
    fx->data[0] = face_inf;
    it = el.succ(it);
   }

  return source(e1);
}

