/*******************************************************************************
+
+  LEDA 3.5
+
+  _error.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <LEDA/basic.h>

/* moved to _global.c
 * LedaErrorHandler std_error_handler = default_error_handler;
 */


void default_error_handler(int i, const char* s)
{ 
  cerr << endl;

  if (i==0) 
     cerr << "LEDA WARNING" << endl;
  else 
     cerr << "LEDA ERROR HANDLER" <<endl;

  cerr << "\t" << s << endl; 
  cerr << endl;
  cerr.flush();

  if (i > 0) abort();
}


LedaErrorHandler set_error_handler(LedaErrorHandler handler)
{ LedaErrorHandler old = error_handler;
  std_error_handler = handler;
  return old;
}

