/*******************************************************************************
+
+  LEDA 3.5
+
+  ugraph.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_UGRAPH_H
#define LEDA_UGRAPH_H

#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350134
#include <LEDA/REDEFINE_NAMES.h>
#endif


#include <LEDA/graph.h>


//-----------------------------------------------------------------------------
// ugraph: base class for all undirected graphs
//
// S. Naeher (1995)
//-----------------------------------------------------------------------------


/*{\Manpage {ugraph} {} {Undirected Graphs}}*/

class ugraph : public graph {

/*{\Mdefinition
An instance $U$ of the data type $ugraph$ is an undirected graph as defined
in section \ref{Graphs}. }*/

public:

/*{\Mcreation U }*/

ugraph()  { make_undirected(); }
/*{\Mcreate creates an instance |\Mvar| of type |\Mname| and initializes it to 
            the empty undirected graph. }*/

ugraph(const graph& G) : graph(G) { make_undirected(); }
/*{\Mcreate creates an instance |\Mvar| of type |\Mname| and initializes it with 
            an undirected copy of $G$. }*/

ugraph(const ugraph& u) : graph(u) {} 

~ugraph() {}

ugraph& operator=(const ugraph& u) 
{ graph::operator=(u); return *this; }

};

/*{\Moperations 2 4}*/

/*{\Mtext       
see section \ref{Graphs}.
}*/


/*{\Mimplementation
see section \ref{Graphs}.
}*/



//------------------------------------------------------------------------------
// UGRAPH: generic ugraphs
//------------------------------------------------------------------------------

/*{\Manpage {UGRAPH} {vtype,etype} {Parameterized Ugraphs}}*/

template<class vtype, class etype>

class UGRAPH : public GRAPH<vtype,etype> {

/*{\Mdefinition
A parameterized undirected graph $G$ is an undirected graph whose nodes and
contain additional (user defined) data (cf. \ref{Parameterized Graphs}). Every 
node contains an element of a data type $vtype$, called the node type of $G$ 
and every edge contains an element of a data type $etype$ called the edge type 
of $G$. }*/

public:

/*{\creation G }*/

UGRAPH() { make_undirected(); }
/*{\Mcreate creates an instance |\Mvar| of type $ugraph$ and initializes it to the
    empty undirected graph.}*/

UGRAPH(const GRAPH<vtype,etype>& G) : GRAPH<vtype,etype>(G) 
{ make_undirected(); }

UGRAPH(const UGRAPH<vtype,etype>& U) : GRAPH<vtype,etype>(U) {}

~UGRAPH() {}


UGRAPH<vtype,etype>& operator=(const UGRAPH<vtype,etype>& a)
{ clear_all_entries();
  graph::operator=(a);
  copy_all_entries();
  return *this; 
 }


/*{\Moperations 2 4.5}*/


/*{\Mtext
see section \ref{Parameterized Graphs}.
}*/

};


/*{\Mimplementation
see section \ref{Parameterized Graphs}.
}*/


extern void complete_ugraph(ugraph&,int);
extern void random_ugraph(ugraph&,int,int);
extern void test_ugraph(ugraph&);


#if LEDA_ROOT_INCL_ID == 350134
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif
