
// class for mutual exclusion using the posix thread library 

#include <pthread.h>
#include <errno.h>

class leda_mutex {

  leda_mutex(const leda_mutex& m) { pthread_mutex_init (&lock_, NULL); } 

  leda_mutex operator=(const leda_mutex& m) 
  { pthread_mutex_init (&lock_, NULL); return *this; }

public:
  leda_mutex() { pthread_mutex_init (&lock_, NULL); }
 ~leda_mutex() { pthread_mutex_destroy (&lock_); }


  void acquire() { pthread_mutex_lock (&lock_); }
  void lock()    { pthread_mutex_lock (&lock_); }
  void enter()   { pthread_mutex_lock (&lock_); }

  void release() { pthread_mutex_unlock (&lock_); }
  void unlock()  { pthread_mutex_unlock (&lock_); }
  void exit()    { pthread_mutex_unlock (&lock_); }

  int trylock()  { return pthread_mutex_trylock (&lock_); }
  int tryenter() { return pthread_mutex_trylock (&lock_); }
  

private:

  pthread_mutex_t lock_;

}; 
