
// class for mutual exclusion using the CPS-library of the CONVEX

#include <cps.h>
#include <errno.h>

class leda_mutex {

  leda_mutex(const leda_mutex& m) 
  { cps_mutex_alloc(&lock_);} 

  leda_mutex operator=(const leda_mutex& m) 
  { cps_mutex_alloc(&lock_); return *this; }

public:
  leda_mutex() { cps_mutex_alloc (&lock_); }
 ~leda_mutex() { cps_mutex_free (&lock_);  }


  void acquire() { cps_mutex_lock (&lock_); }
  void lock()    { cps_mutex_lock (&lock_); }
  void enter()   { cps_mutex_lock (&lock_); }

  void release() { cps_mutex_unlock (&lock_); }
  void unlock()  { cps_mutex_unlock (&lock_); }
  void exit()    { cps_mutex_unlock (&lock_); }

  int trylock()  { return cps_mutex_trylock (&lock_); }
  int tryenter() { return cps_mutex_trylock (&lock_); }
  

private:
  cps_mutex_t lock_;

}; 
