#ifndef LEDA_SYS_UNIX_H
#define LEDA_SYS_UNIX_H


//----------------------------------------------------------------------------
// system/compiler dependent definitions 
//----------------------------------------------------------------------------

// In the first section of this file some flags are defined indicating
// that certain c++ features are supported or not by particular compilers. 
// If your compiler does not appear you may have to add it.
// 
// __HAS_BUILTIN_BOOL__       : has built-in boolean
// __HAS_VALUES_H__           : has <values.h> header file 
// __NO_TEMPLATE_FUNCTIONS__  : no function templates (or to many problems)
// __NO_TEMPLATE_ARG_BASE__   : template arguments may not be used as base class
// __NO_EXPLICIT_DESTRUCTION__: no explicit destructor call
// __NO_INPLACE_NEW__         : no in-place new operator
// __NO_VOLATILE__            : no "volatile" keyword
// __ELSE_SCOPE_BUG__         : else-part does not start new scope


#if !defined(unix) 
#define unix
#endif

#if defined(__SVR4) || defined(_SYSTYPE_SVR4) || defined(__SYSTYPE_SVR4)
#if !defined(__svr4__)
#define __svr4__
#endif
#endif

#if !defined(__GNUC__)
#if defined(hpux)
#define __hpuxcc__
#endif
#if defined(mips) && _COMPILER_VERSION < 602
#define __mipspro_before_602__
#endif
#endif


#define __HAS_VALUES_H__
#define __TEMPLATE_FUNCTIONS__



#if defined(_BOOL) || defined(__GNUC__)
#define __HAS_BUILTIN_BOOL__
#endif

#if defined(__hpuxcc__) || defined(__mipspro_before_602__)
#define __ELSE_SCOPE_BUG__
#endif



#if defined(__ATTCFRONT__) || defined(__lucid) || defined(__hpuxcc__) 
#define __NO_TEMPLATE_ARG_BASE__
#endif



#if defined(__DECCXX)
#define __NO_EXPLICIT_DESTRUCTION__
#endif

#if defined(__ATTCFRONT__)
#define __NO_EXPLICIT_DESTRUCTION__
#endif

#if defined(__mipspro_before_602__)
#define __NO_EXPLICIT_DESTRUCTION__
#endif

#if defined(__xlC__)
#define __NO_EXPLICIT_DESTRUCTION__
#endif

#if defined(__IBMCPP__)
#define __NO_EXPLICIT_DESTRUCTION__
#endif


#if defined(__hpuxcc__)
#define __NO_VOLATILE__
#endif

#if defined(linux)
#define LITTLE_ENDIAN_MACHINE
#endif

#if defined(__STDC__)
#define STRINGIZE(x) #x
#else
#define STRINGIZE(x) "x"
#endif


#define __exportC
#define __exportF
#define __exportD

#endif
