/*******************************************************************************
+
+  LEDA 3.5
+
+  stream.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_STREAM_H
#define LEDA_STREAM_H

#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350126
#include <LEDA/REDEFINE_NAMES.h>
#endif

#include <LEDA/basic.h>
#include <fstream.h>

#if defined(__EIGHT_CHAR_FILE_NAMES__)
#include <strstrea.h>
#else
#include <strstream.h>
#endif

/*{\Manpage {file_istream} {} {File Input Streams} }*/


struct file_istream : public ifstream {

/*{\Mdefinition
An instanc $I$ of the data type $file\_istream$ is an \CC istream
connected to a file $F$, i.e., all input operations or operators
applied to $I$ read from $F$. }*/

/*{\Mcreation I }*/

/*{\Moptions nextwarning=no}*/
file_istream(char*  s) : ifstream(s) {}
file_istream(string s) : ifstream(~s) {}
/*{\Mcreate    creates an instance $I$ of type file\_istream connected to 
               file $s$. }*/


/*{\Moperations 2 5.5 }*/

/*{\Mtext
All operations and operators ($>>$) defined for \CC istreams can
be applied to file input streams as well.
}*/

  bool open(string s)  { ifstream::open(~s); return !fail(); }

};




/*{\Manpage {file_ostream} {} {File Output Streams} }*/


struct file_ostream : public ofstream {

/*{\Mdefinition
An instance $O$ of the data type $file\_ostream$ is an \CC ostream
connected to a file $F$, i.e., all output operations or operators
applied to $O$ write to $F$. }*/

/*{\Mcreation O }*/

/*{\Moptions nextwarning=no}*/
file_ostream(string s) : ofstream(~s) {}
file_ostream(char*  s) : ofstream(s) {}
/*{\Mcreate    creates an instance $O$ of type file\_ostream connected to 
               file $s$.}*/ 


/*{\Moperations 2 5.5 }*/

/*{\Mtext
All operations and operators ($<<$) defined for \CC ostreams can
be applied to file output streams as well.
}*/

 bool open(string s)  { ofstream::open(~s); return !fail(); }

};




/*{\Manpage {string_istream} {} {String Input Streams} }*/

struct string_istream : public istrstream {

/*{\Mdefinition
An instance $I$ of the data type $string\_istream$ is an \CC istream
connected to a string $s$, i.e., all input operations or operators
applied to $I$ read from $s$. }*/

/*{\Mcreation I }*/


/*{\Moptions nextwarning=no}*/
string_istream(const char* s)  : istrstream((char*)s) {}
string_istream(string s) : istrstream((char*)~s) {}
/*{\Mcreate   creates an instance $I$ of type string\_istream connected to 
              the string $s$. }*/

string_istream(int argc, char** argv) : istrstream((char*)~string(argc,argv)) {}


/*{\Moperations 2 5.5 }*/

/*{\Mtext
All operations and operators ($>>$) defined for \CC istreams can
be applied to string input streams as well.
}*/


 };





/*{\Manpage {string_ostream} {} {String Output Streams} }*/

struct string_ostream : public ostrstream {

/*{\Mdefinition
    An instance $O$ of the data type $string\_ostream$ is an \CC ostream
    connected to an internal string buffer, i.e., all output operations 
    or operators applied to $O$ write into this internal buffer.  The current
    value of the buffer is called the contents of $O$.}*/


/*{\Mcreation O }*/

string_ostream() {};
/*{\Mcreate creates an instance $O$ of type string\_ostream.}*/


/*{\Moperations 2 5.5 }*/

string str()     { return ostrstream::str(); };
/*{\Mop   returns the current contents of $O$.}*/


/*{\Mtext
All operations and operators ($<<$) defined for \CC ostreams can
be applied to string output streams as well.
}*/

};



#if !defined(unix) || defined(__lucid)

typedef file_ostream cmd_ostream;
typedef file_istream cmd_istream;

#else


#include <stdio.h>


/*{\Manpage {cmd_istream} {} {Command Input Streams} }*/


struct cmd_istream : public ifstream 
{ 

/*{\Mdefinition
An instance $I$ of the data type $cmd\_istream$ is an \CC istream
connected to the output of a shell command $cmd$, i.e., all input operations
or operators applied to $I$ read from the standard output of command $cmd$. }*/

/*{\Mcreation I }*/

/*{\Moptions nextwarning=no}*/

  cmd_istream(char*  cmd) : ifstream(fileno(popen(cmd,"r"))) {} 
  cmd_istream(string cmd) : ifstream(fileno(popen(~cmd,"r"))) {}

/*{\Mcreate   creates an instance $I$ of type cmd\_istream connected to the 
              output of command $cmd$. }*/


/*{\Moperations 2 5.5 }*/

/*{\Mtext
All operations and operators ($>>$) defined for \CC istreams can
be applied to command input streams as well.
}*/

 };





/*{\Manpage {cmd_ostream} {} {Command Output Streams} }*/

struct cmd_ostream : public ofstream {

/*{\Mdefinition
An instance $O$ of the data type $cmd\_ostream$ is an \CC ostream
connected to the input of a shell command $cmd$, i.e., all output operations
or operators applied to $O$ write into the standard input of command $cmd$. }*/

/*{\Mcreation O }*/

/*{\Moptions nextwarning=no}*/
cmd_ostream(char*  cmd) : ofstream(fileno(popen(cmd,"w"))) {}
cmd_ostream(string cmd) : ofstream(fileno(popen(~cmd,"w"))) {}
/*{\Mcreate
creates an instance $O$ of type cmd\_ostream connected to the input of 
command $cmd$.  }*/


/*{\Moperations 2 5.5 }*/

/*{\Mtext
All operations and operators ($<<$) defined for \CC ostreams can
be applied to command output streams as well.
}*/

};

#endif


#if LEDA_ROOT_INCL_ID == 350126
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif

