/*******************************************************************************
+
+  LEDA 3.5
+
+  stl.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_STL_H
#define LEDA_STL_H

#define deque  stl_deque
#define list   stl_list
#define map    stl_map
#define set    stl_set
#define stack  stl_stack
#define vector stl_vector

#if defined(__GNUC__)
#include <stl.h>
#else
#define RWSTD_NO_NAMESPACE
#include <deque.h>
#include <list.h>
#include <map.h>
#include <set.h>
#include <stack.h>
#include <vector.h>
#endif

#undef deque
#undef list
#undef map
#undef set
#undef stack
#undef vector

#endif
