/*******************************************************************************
+
+  LEDA 3.5
+
+  dic_impl.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/


typedef int dic_impl_item;

class dic_impl {

private:

virtual int  key_type_id()       const = 0;

virtual int  cmp(GenPtr, GenPtr) const = 0;
virtual void clear_key(GenPtr&)  const = 0;
virtual void clear_inf(GenPtr&)  const = 0;
virtual void copy_key(GenPtr&)   const = 0;
virtual void copy_inf(GenPtr&)   const = 0;

//
// private data
//


public:

 dic_impl();
 dic_impl(const dic_impl&);
~dic_impl();

dic_impl& operator=(const dic_impl&);

GenPtr key(dic_impl_item p)  const;
GenPtr inf(dic_impl_item p)  const;

dic_impl_item insert(GenPtr,GenPtr);
dic_impl_item lookup(GenPtr)  const;
dic_impl_item first_item()    const;
dic_impl_item next_item(dic_impl_item) const;
dic_impl_item item(GenPtr)    const;

void    change_inf(dic_impl_item,GenPtr);
void    del_item(dic_impl_item);
void    del(GenPtr);
void    clear();

int     size() const;

};



