/*******************************************************************************
+
+  LEDA 3.5
+
+  geo_rep.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_GEO_REP_H
#define LEDA_GEO_REP_H 

#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350047
#include <LEDA/REDEFINE_NAMES.h>
#endif


#include <LEDA/integer.h>
#include <LEDA/integer_vector.h> 

class geo_rep : public handle_rep {

friend class rat_vector;

 int      dim;
 integer* v;

 geo_rep();
 geo_rep(int d);
 geo_rep(integer,integer,integer);
 geo_rep(integer,integer,integer,integer);
 geo_rep(const integer_vector&);
 geo_rep(const integer_vector&,integer);
~geo_rep();


static integer* allocate(int);
static void     deallocate(integer*, int);
static int cmp_rat_coords(geo_rep*,geo_rep*);
static int cmp_hom_coords(geo_rep*,geo_rep*);

integer_vector vec() const;

void init3(integer,integer,integer);
void init4(integer,integer,integer,integer);
void copy(geo_rep*);
void negate(int);

friend ostream& operator<<(ostream&out,geo_rep*p);
friend istream& operator>>(istream&in,geo_rep*p);
friend void c_add(geo_rep*res,geo_rep*a,geo_rep*b);
friend void c_sub(geo_rep*res,geo_rep*a,geo_rep*b);

LEDA_MEMORY(geo_rep)

};


#if LEDA_ROOT_INCL_ID == 350047
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif



