#include <LEDA/plane.h>
#include <LEDA/window.h>

enum { POINT, SEGMENT, RAY, LINE, CIRCLE, DISC, POLY};

static char* image = 0;

static window W(500,600);

void scroll_x(int x) 
{ if (image)
  { W.put_pixrect(x,W.ymin(),image); 
    W.draw_box(W.xmin(),W.ymin(),x,W.ymax(),white);
   }
 }

void scroll_y(int y)
{ if (image)
  { W.put_pixrect(W.xmin(),y,image); 
    W.draw_box(W.xmin(),W.ymin(),W.xmax(),y,white);
   }
}


void redraw(window* wp)
{ if (image) 
    W.put_pixrect(W.xmin(),W.ymin(),image); 
 }


int main()
{
  color fg_col = blue;
  color bg_col = white;
  int   shape  = DISC;
  int   x_origin = 0;
  int   y_origin = 0;

  list<string> shapes;
  shapes.append("point");
  shapes.append("seg");
  shapes.append("ray");
  shapes.append("line");
  shapes.append("circ");
  shapes.append("disc");
  shapes.append("poly"); 

  W.color_item ("foreground",fg_col);
  //W.color_item ("background",bg_col);
  W.choice_item("shape",shape,shapes);

  //W.int_item("scroll-x",x_origin,0,1000,scroll_x);
  //W.int_item("scroll-y",y_origin,0,1000,scroll_y);

  W.button("clear",1);
  W.button("quit",2);

  W.open(window::center,window::center);

  W.init(0,1000,0);

  W.set_redraw(redraw);

  //W.open(window::center,window::center);

  for(;;)
  { 
    double x;
    double y;

    int k = W.read_mouse(x,y);

    W.set_fg_color(fg_col);
    W.set_bg_color(bg_col);

    if (k==1) 
    { W.clear();
      continue;
     }

    if (k==2) break;

    put_back_event();
  
    switch (shape) {

        case POINT: 
             { point p;
               if (W >> p) W.draw_point(p);
               break;
              }
  
        case SEGMENT: 
             { segment s;
               if (W >> s) W.draw_segment(s);
               break;
              }


        case RAY: 
             { ray r;
               if (W >> r) W.draw_ray(r);
               break;
              }
  

        case LINE: 
             { line l;
               if (W >> l) W.draw_line(l);
               break;
              }
  
  
        case CIRCLE: 
             { circle c;
               if (W >> c) W.draw_circle(c);
               break;
              }

        case DISC: 
             { circle c;
               if (W >> c)
               { W.draw_disc(c);
                 W.draw_circle(c,black);
                }
               break;
              }
  
        case POLY: 
             { polygon P;
               if (W >> P) 
               { W.draw_filled_polygon(P);
                 W.draw_polygon(P,black);
                }
               break;
              }

       }

      if (image) W.del_pixrect(image);

      image = W.get_window_pixrect();
  }

  return 0;
}
