#include <LEDA/window.h>
#include <math.h>

// double click demo

int main()
{
  int timeout = 160;

  window W(500,550,"Double Click Demo");
  W.int_item("timeout", timeout, 0, 300);
  W.init(0,100,0,5);
  W.set_show_cursor(false);
  W.display();

  int    key;
  double x,y,x0,y0;
  unsigned long t;

  double r = 2;

  for(;;)
  { 
    int b = W.read_mouse(x0,y0);

    if (b == MOUSE_BUTTON(3) ) break;  

    // wait for release event

    while (W.read_event(key,x,y) != button_release_event); 
    unsigned long rt = W.button_release_time() - W.button_press_time();

    if (rt < timeout && W.read_event(key,x,y,t,timeout) == button_press_event)
      { // double click: erase node
        W.draw_disc(x0,y0,r,white);
        W.draw_pix(x0,y0,black);
       }
    else
      { // single click: new node
        W.draw_disc(x0,y0,r,red);
        W.draw_circle(x0,y0,r,black);
       }

   }

  return 0;
}
