#include <LEDA/vector.h>
#include <LEDA/matrix.h>
#include <LEDA/list.h>



main()

{ 
  int d = read_int("dimension = ");

  matrix       A(d,d);
  vector       b(d);
  vector       x(d);

  list<vector> B;  // List of b-vectors
  list<vector> X;  // List of x-vectors

  cout << string("give (%d x %d) matrix A:",d,d) << endl;
  A.read();

  cout << "A = ";
  A.print();
  newline;

  cout << "A.trans() = ";
  A.trans().print();
  newline;


  cout << "A.inv() = ";
  A.inv().print();
  newline;

  cout << "A*A.inv() = ";
  (A*A.inv()).print();
  newline;
  

  cout << "We solve the system of linear equations A*x = b.\n";
  cout << "Give a list of vectors b (terminated by ctrl-d):\n";

  while (cin) 
  { b.read(cin);
    B.append(b);
   }

  cout << "List of b's = " << endl;
  forall(b,B)
  { b.print();
    newline;
   }
  newline;

  forall(b,B) X.append(A.solve(b));
  
  cout << "List of x's = " << endl;
  forall(x,X)
  { x.print();
    newline;
   }
  newline;


  cout << "List of A*x's = " << endl;
  forall(x,X) 
  { (A*x).print();
     newline;
   }
  newline;
 
  return 0;
}
