#include <LEDA/graph_alg.h>

main()
{
  graph G;
  
  int n = read_int("n = ");

  bool embed = Yes("embed (y/n): ");
  int  i = 0;

  for(;;)
  {

  random_graph(G,n,rand_int(n/2,n));

  Delete_Loops(G);

/*
  int loop_count = 0;
  edge e;
  forall_edges(e,G)
      if (source(e) == target(e)) loop_count++;

  cout << "loop_count = " << loop_count << endl;
*/

  if (embed)
  { Make_Biconnected(G);
    Make_Bidirected(G);
   }

  list<edge> el = G.all_edges();

  float t,T;

  cout << "Hocroft/Tarjan:  " << flush;
  T = used_time();
  bool  p0 = HT_PLANAR(G,embed);  
  t = used_time(T);
  cout << ( p0 ? " is planar" : "not planar");
  cout << string("%5.2f ",t) << endl;

  G.sort_edges(el);

  cout << "Booth/Luecker:   " << flush;
  T = used_time();
  bool  p1 = BL_PLANAR(G,embed);  
  t = used_time(T);
  cout << ( p1 ? " is planar" : "not planar");
  cout << string("%5.2f ",t) << endl;

  if (p1 != p0 ) 
  { G.write("plan_test.lgr");
    error_handler(1,"error in plan_test");
   }

   newline;

 }

  return 0;
}
