#include <LEDA/array.h>

int ord(const int& x) { return x%1000; }

int main () 
{

  int i;

  int N = read_int("Number of array entries: "); 

  float T = used_time();


  cout << "allocating    ";
  cout.flush();

  array<int>     A(N);
  array<int>     A1(N);
  array<double>  A2(N);

  for(i=0; i<N; i++) A[i] = rand_int(0,100000);

  cout << string("  %5.3f sec",used_time(T));
  newline;

  cout << "assignment    ";
  cout.flush();
  A = A1;
  cout << string("  %5.3f sec",used_time(T));
  newline;

  cout << "sorting(int)  ";
  cout.flush();
  A.sort();
  cout << string("  %5.3f sec",used_time(T));
  newline;

  cout << "sorting again ";
  cout.flush();
  A.sort();
  cout << string("  %5.3f sec",used_time(T));
  newline;


  cout << "iteration     ";
  cout.flush();
  forall(i,A) {}
  cout << string("  %5.3f sec",used_time(T));
  newline;

  for(i=0; i<N; i++) A2[i] = A[i];

  cout << "sorting(double)";
  cout.flush();
  A2.sort();
  cout << string("  %5.3f sec",used_time(T));
  newline;


  cout << "sorting again ";
  cout.flush();
  A2.sort();
  cout << string("  %5.3f sec",used_time(T));
  newline;



  cout << "test sorting  ";
  cout.flush();
  for(i=0; i<N; i++) { 
    if (A[i] != A2[i])  cout << string("%d  != %f\n",A[i],A2[i]);
  }
  cout << string("  %5.3f sec",used_time(T));
  newline;
  
  newline;
  cout << "used memory = " << used_memory()/1024.0 << " kb\n";

  return 0;
}
