/*******************************************************************************
+
+  LEDA 3.5
+
+  _dos_wcc.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <graph.h>

void init_graphics(int mode, int& width, int& height, int& depth)
{ 
  if (mode == 1) // graphics mode
  { 
    videoconfig vconf; 

    if (_setvideomode(_XRES16COLOR) == _UNKNOWN && 
        _setvideomode(_SVRES16COLOR) == _UNKNOWN)
        _setvideomode(_VRES16COLOR);

    _getvideoconfig(&vconf);
    _setviewport(0,0,vconf.numxpixels-1,vconf.numypixels-1);

    width = vconf.numxpixels;
    height= vconf.numypixels;
    depth = vconf.bitsperpixel;
   }
  else
    _setvideomode(_DEFAULTMODE);

}


void define_color(int index, int red, int green, int blue)
{ red   /= 4;
  green /= 4;
  blue  /= 4;
  _remappalette(index, (blue<<16) | (green<<8) | red);
}



void draw_pixel(int x, int y, unsigned char c) 
{ _setcolor(c);
  _setpixel(x,y); 
}


void  draw_scan_segment(unsigned char* p, int x, int y, int len)
{ while (len--) 
  { _setcolor(*p++);
    _setpixel(x++,y); 
   }
}


int   check_next_event(int& val, int& x, int& y, int block)
{ return 0; }

