/*******************************************************************************
+
+  LEDA 3.5
+
+  delaunay.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/

void DELAUNAY_TRIANG(const list<POINT>& L, GRAPH<POINT,int>& G)
{ DELAUNAY_DWYER(L,G); }


void DELAUNAY_DIAGRAM(const list<POINT>& L, GRAPH<POINT,int>& DT)
{ 
  DELAUNAY_TRIANG(L,DT);

  list<edge> el;
  edge e;
  forall_edges(e,DT)
      if (DT[e] == NON_DIAGRAM_EDGE) el.append(e);

  forall(e,el) DT.del_edge(e);
}


void F_DELAUNAY_TRIANG(const list<POINT>& L, GRAPH<POINT,int>& G)
{ F_DELAUNAY_FLIP(L,G); }


void F_DELAUNAY_DIAGRAM(const list<POINT>& L, GRAPH<POINT,int>& DT)
{ 
  F_DELAUNAY_TRIANG(L,DT);

  list<edge> el;
  edge e;
  forall_edges(e,DT)
      if (DT[e] == NON_DIAGRAM_EDGE) el.append(e);

  forall(e,el) DT.del_edge(e);
}


