/*******************************************************************************
+
+  LEDA 3.5
+
+  _x_basic.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <LEDA/impl/x_basic.h>
#include <stdio.h>
#include <stdlib.h>

#if defined(__win32__)

#if defined(__GNUC__)
#include <wingnuc.h>
#endif

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <commdlg.h>


void x_open_display(void)  
{ 

char* msg = "\
The LEDA Research Version does not include GUI support for win32 \
systems. Please contact the LEDA Software GmbH for information on how \
to obtain a release including full graphics support for your platform.\n\n\
LEDA Software GmbH\n\
Postfach 151101\n\
66041 Saarbruecken\n\
Germany\n\
email:leda@mpi-sb.mpg.de\n\
fax: +49 681 842502\n\n";

  MessageBox(NULL,msg,"LEDA Research Version 3.5",MB_OK | MB_ICONINFORMATION);

  exit(1);
}

#else

void x_open_display(void)  
{ 
char* msg = "\
The LEDA Research Version does not include GUI support for win32 \
systems. Please contact the LEDA Software GmbH for information on how \
to obtain a release including full graphics support for your platform.\n\n\
LEDA Software GmbH\n\
Postfach 151101\n\
66041 Saarbruecken\n\
Germany\n\
email:leda@mpi-sb.mpg.de\n\
fax: +49 681 842502\n\n";

printf(msg);
exit(1);
}

#endif


void x_close_display(void) {}
void x_flush_display(void) {}
int x_display_width(void)  { return 0; }
int x_display_height(void) { return 0; }
int x_display_depth(void)  { return 0; }
int x_display_bits_saved(void) { return 1; }

int x_create_buffer(int win) { return 0; } 

void x_start_buffering(int win) {} 
void x_start_buffering(int win,int,int) {} 

void x_flush_buffer(int win,int x1,int y1,int x2,int y2,int xoff,int yoff) {}
void x_flush_buffer(int win, int x1, int y1, int x2, int y2)  {}
void x_stop_buffering(int win) {}
void x_delete_buffer(int win) {}
char* x_get_buffer_pixrect(int win) { return 0; } 



/* windows */

void x_grab_pointer(int) {}
void x_ungrab_pointer() {} 


int x_create_window(void* inf, int width,int height,int bg_col, 
                       const char* header, const char* label, 
                       int pwin, void (*func)(void*))
{ return 0; }


void x_set_clip_rect(int win, int x0, int y0, int w, int h)  {}
void x_open_window(int win, int x, int y, int width,int height,int pwin) {}
void x_close_window(int win) {}
void x_destroy_window(int win)  {}
void x_set_header(int win, const char *s) {}
void x_start_timer(int win, int msec) {}
void x_stop_timer(int win) {}

int x_window_opened(int win)  { return 0; }
int x_window_width(int win) { return 0; }
int x_window_height(int win) { return 0; }

void* x_window_inf(int win) { return 0; }

void x_window_position(int win, int* x, int* y) {}
void x_clear_window(int) {}



void x_line(int win, int x1, int y1, int x2, int y2) {}
void x_lines(int win, int n, int *x1, int *y1, int* x2, int* y2) {}
void x_rect(int win, int x1, int y1, int x2, int y2) {}
void x_box(int win, int x1, int y1, int x2, int y2) {}
void x_circle(int win, int x, int y, int r) {}
void x_fill_circle(int win, int x, int y, int r) {}
void x_polygon(int win, int n, int* xcoord, int* ycoord) {}
void x_fill_polygon(int win, int n, int* xcoord, int* ycoord) {}
void x_pixel(int win, int x, int y) {}
int  x_get_pixel(int win, int x, int y) { return 0; }
void x_pixels(int win, int n, int* x, int* y) {}
void x_point(int win, int x, int y) {}
void x_arc(int win,int mx,int my,int r1,int r2,double start,double angle) {}
void x_fill_arc(int, int, int, int, int, double, double) {}
void x_ellipse(int win, int x, int y, int r1, int r2) {}
void x_fill_ellipse(int win, int x, int y, int r1, int r2) {}
void x_text(int win, int x, int y, const char* s0, int l) {}
void x_text(int win, int x, int y, const char* s) {}
void x_ctext(int win, int x, int y, const char* s) {}

char* x_create_bitmap(int win, int w, int h, char* data) { return 0; }
char* x_create_pixrect(int win, int w, int h, char* data, int fc, int bc) { return 0; }
char* x_create_pixrect(int win, int x1, int y1, int x2, int y2) { return 0; }
void x_insert_pixrect(int win, int x, int y, char* rect) {}
void x_insert_pixrect(int win, int x, int y, char* rect, int x0, int y0, int x1, int y1) {}
void x_insert_pixrect(int win, char* rect) {}
void x_insert_bitmap(int win, int x, int y, char* rect) {}
void x_delete_bitmap(char* rect) {}
void x_delete_pixrect(char* rect) {}
void x_copy_pixrect(int win, int x1, int y1, int x2, int y2, int x, int y) {}

int x_load_text_font(const char* font_name)  { return 1; }
int x_load_bold_font(const char* font_name)  { return 0; }
int x_load_fixed_font(const char* font_name) { return 0; }
int x_set_font(int win, const char* fname){ return 0; }

void x_set_text_font(int win)  {}
void x_set_bold_font(int win)  {}
void x_set_fixed_font(int win) {}

int x_text_width(int win,const char* s) { return 0; }
int x_text_width(int win,const char* s, int l) { return 0; }
int x_text_height(int win,const char* s)  { return 0; }

int          x_set_color(int win, int col)            { return 0; }
drawing_mode x_set_mode(int win, drawing_mode mod)    { return src_mode; }
int          x_set_line_width(int win, int lw)        { return 0; }
line_style   x_set_line_style(int win, line_style ls) { return solid; }
text_mode    x_set_text_mode(int win, text_mode tm)   { return transparent; }
int          x_set_join_style(int win, int js)        { return 0; }

int           x_get_color(int win)      { return 0; }
drawing_mode  x_get_mode(int win)       { return src_mode; }
int           x_get_line_width(int win) { return 0; }
line_style    x_get_line_style(int win) { return solid; }
text_mode     x_get_text_mode(int win)  { return transparent; }

void x_set_read_gc(int win) {}
void x_reset_gc(int win) {}

void x_set_palette(int i, int r, int g, int b) {}
void x_get_palette(int i, int* red, int* green, int* blue) {}
int x_new_color(const char*) { return 0; }
int x_new_color(int,int,int) { return 0; }


int x_get_next_event(int* win, int* val, int* x, int* y, unsigned long *t, int msec)
{ return 0; }
int x_get_next_event(int* win, int* val, int* x, int* y, unsigned long *t)
{ return 0; }
int x_check_next_event(int* win, int* val, int* x, int* y, unsigned long *t)
{ return 0; }

void x_put_back_event(void) {}
void x_set_border_width(int, int) {}

void  x_window_to_screen(int, int*, int*) {}
void  x_screen_to_window(int, int*, int*) {}
void  x_set_icon_pixmap(int, char*) {}
char* x_create_pixrect(int, char**) { return 0; }
void  x_pixrect_dimensions(char*, int*, int*) {}

void  x_resize_window(Window win, int width,int height)  {}
