/*******************************************************************************
+
+  LEDA 3.5
+
+  _tamassia.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <LEDA/graph_draw.h>

int TAMASSIA_EMBEDDING(const graph& G, node_array<double>& xpos,  
                                       node_array<double>& ypos,  
                                       edge_array<list<double> >& xbends,
                                       edge_array<list<double> >& ybends,
                                       bool check)
{
  node_array<int> ixpos(G);
  node_array<int> iypos(G);
  edge_array<list<int> > ixbends(G);
  edge_array<list<int> > iybends(G);
  int n_bends = ORTHO_EMBEDDING(G,ixpos,iypos,ixbends,iybends,check);

  xpos.init(G);
  ypos.init(G);
  xbends.init(G);
  ybends.init(G);

  node v;
  forall_nodes(v,G)
  { xpos[v] = ixpos[v];
    ypos[v] = iypos[v];
   }

  edge e;
  forall_edges(e,G)
  { list<double> lx;
    list<double> ly;
    int i;
    forall(i,ixbends[e]) lx.append(i);
    forall(i,iybends[e]) ly.append(i);
    xbends[e] = lx;
    ybends[e] = ly;
   }
    
  return n_bends;
}

