/*******************************************************************************
+
+  LEDA 3.5
+
+  _global.c
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#include <LEDA/basic.h>

const char* LEDA::version_string = "LEDA 3.5c";

const char* LEDA::copyright_string = 
"LEDA 3.5c (c) 1991-1997 Max-Planck-Institut fuer Informatik, Saarbruecken";


#if defined(__GNUC__)
const char* LEDA::compiler_string = "GNU g++";
#elif defined(__SUNPRO_CC)
const char* LEDA::compiler_string = "SUN c++";
#elif defined(__hpuxcc__)
const char* LEDA::compiler_string = "HP  c++";
#elif defined(__xlC__)
const char* LEDA::compiler_string = "IBM c++";
#elif defined(__DECCXX)
const char* LEDA::compiler_string = "DEC c++";
#else
const char* LEDA::compiler_string = "???????";
#endif

const char* LEDA::compiler_date   = __DATE__;


#if defined(LEDAROOT)
const char* LEDA::rootdir_name   =  STRINGIZE(LEDAROOT);
#else
const char* LEDA::rootdir_name   = "/LEDA/BETA";
#endif



char* LEDA::option_list     = 0;
int   LEDA::node_data_slots = 0;
int   LEDA::edge_data_slots = 0;
int   LEDA::face_data_slots = 0;


LedaErrorHandler std_error_handler = default_error_handler;

unsigned memory_manager_init::count;

memory_manager std_memory_mgr;

random_source rand_int;

