
// class for mutual exclusion using the solaris thread library 

#include <thread.h>
#include <errno.h>

class leda_mutex {

  leda_mutex(const leda_mutex& m) { mutex_init(&lock_, 0, NULL); } 

  leda_mutex operator=(const leda_mutex& m) 
  { mutex_init (&lock_, 0, NULL); return *this; }

public:
  leda_mutex() { mutex_init (&lock_, 0 , NULL); }
 ~leda_mutex() { mutex_destroy (&lock_); }


  void acquire() { mutex_lock (&lock_); }
  void lock()    { mutex_lock (&lock_); }
  void enter()   { mutex_lock (&lock_); }

  void release() { mutex_unlock (&lock_); }
  void unlock()  { mutex_unlock (&lock_); }
  void exit()    { mutex_unlock (&lock_); }

  int trylock()  { return mutex_trylock (&lock_); }
  int tryenter() { return mutex_trylock (&lock_); }
  

private:
  mutex_t lock_;

}; 
