/*******************************************************************************
+
+  LEDA 3.5
+
+  bb_tree.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/

#ifndef LEDA_BB_TREE_H
#define LEDA_BB_TREE_H

//------------------------------------------------------------------------------
//
// bb_tree:  
//
//           BB[alpha] trees (derived from class "bin_tree")
//
// Stefan N"aher (1993)
//
//------------------------------------------------------------------------------


#include <LEDA/basic.h>
#include <LEDA/impl/bin_tree.h>

 
typedef bin_tree_node* bb_tree_item;

 
// ----------------------------------------------------------------
// class bb_tree
// ----------------------------------------------------------------

// const float alpha = 0.28;
// const float d     = 0.58;

// we multiply alpha, d, and all balances by 64 to make them integers

  const int alpha = 18; // 0.28 * 64
  const int d = 37;     // 0.58 * 64

class bb_tree : public bin_tree
{ 

  int root_balance() { return 2; }
  int node_balance() { return 2; }
  int leaf_balance() { return 1; }

  void rebal(bb_tree_item,int);
  void insert_rebal(bb_tree_item);
  void del_rebal(bb_tree_item, bb_tree_item);


  float balance(bb_tree_item p)
  { if (p->is_leaf()) 
       return 0.5 ;
    else 
       return float(p->child[left]->get_bal())/p->get_bal();
   }

public:

  bb_tree() {}
 ~bb_tree() {}

  bb_tree(const bb_tree& T) : bin_tree(T) {}

  bb_tree& operator=(const bb_tree& T) 
  { bin_tree::operator=(T); return *this; }

};

#endif
