/*******************************************************************************
+
+  LEDA 3.5
+
+  global.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_GLOBAL_H
#define LEDA_GLOBAL_H

#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350048
#include <LEDA/REDEFINE_NAMES.h>
#endif



//------------------------------------------------------------------------------
// global types, constants, and macros
//------------------------------------------------------------------------------

typedef void* GenPtr;    // generic pointer type

enum { after = 0, before = 1 };

#if defined(LEDA_OLD_ITERATION)
enum { forward = 0, backward = 1 };
#endif

#define nil 0

#define	LEDA_PI   3.14159265358979323846
#define	LEDA_PI_2 1.57079632679489661923

//------------------------------------------------------------------------------
// values
//------------------------------------------------------------------------------

#if defined(__HAS_VALUES_H__)
#include <values.h>
#else
#define MAXINT          int(~(unsigned(1)<<(8*sizeof(int)-1)))
#define MAXFLOAT	(float(3.37E+38))
#define MAXDOUBLE       (double(1.797693E+308))
#endif


//------------------------------------------------------------------------------
// LEDA class 
//------------------------------------------------------------------------------

struct LEDA {

static char* option_list;

static int   node_data_slots;
static int   edge_data_slots;
static int   face_data_slots;

static const char* version_string;
static const char* copyright_string;
static const char* compiler_string;
static const char* compiler_date;
static const char* rootdir_name;

static void  write_log(const char*);
static void  check_license();
static void  user_log();
static void  read_options();
static void  sleep(float);
static float used_time();
static float used_time(float&);
};



#if LEDA_ROOT_INCL_ID == 350048
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif
