/*******************************************************************************
+
+  LEDA 3.5
+
+  error.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_ERROR_H
#define LEDA_ERROR_H

#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350040
#include <LEDA/REDEFINE_NAMES.h>
#endif


/*{\Mtext
\section{Error Handling} \label{Error Handling}

LEDA tests the preconditions of many (not all!) operations. Preconditions
are never tested, if the test takes more than constant time. If the test
of a precondition fails an error handling routine is called. It takes 
an integer error number $i$ and a $char*$ error message string $s$ as 
arguments. It writes $s$ to the diagnostic output (cerr) and terminates 
the program abnormally if $i \ne 0$.
Users can provide their own error handling function $handler$ by calling 
\smallskip
set\_error\_handler($handler$).
\smallskip 
After this function call $handler$ is used instead of the default error 
handler. $handler$ must be a function of type  $void\ \ handler(int,\ char*)$. 
The parameters are replaced by the error number and the error message
respectively. 
}*/


//------------------------------------------------------------------------------
// Error Handling
//------------------------------------------------------------------------------

typedef void (*LedaErrorHandler)(int,const char*);

extern LedaErrorHandler std_error_handler;
extern LedaErrorHandler set_error_handler(LedaErrorHandler);
extern void default_error_handler(int,const char*);

inline void error_handler(int i, const char* s)  { std_error_handler(i,s); }



#ifndef LEDA_CHECKING_OFF
#define LEDA_OPT_PRECOND(cond,fstr) \
if (!(cond)) { cerr << "LEDA PRECONDITION VIOLATION: "fstr"\n"; abort(); }
#else
#define LEDA_OPT_PRECOND(cond,fstr)
#endif

#define LEDA_PRECOND(cond,fstr) \
if (!(cond)) { cerr << "LEDA PRECONDITION VIOLATION: "fstr"\n"; abort(); }



#if LEDA_ROOT_INCL_ID == 350040
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif
