#include <LEDA/window.h>
#include <time.h>

static bool show_sec = true;

static void display_time(window* wp)
{ time_t clock; 
  time(&clock);
  tm* T = localtime(&clock); 
  int s = T->tm_sec;
  int m = T->tm_min;
  int h = T->tm_hour;
  double x = (wp->xmax() - wp->xmin())/2;
  double y = (wp->ymax() - wp->ymin())/2;
  string time("%02d:%02d:%02d",h,m,s);
  wp->set_frame_label(time);
}


main()
{ panel P;
  P.bool_item("seconds",show_sec);
  P.button("continue");
  P.button("exit");
  P.buttons_per_line(2);
  P.display();
  display_time(&P);
  P.start_timer(990,display_time);
  P.read();
  return 0;
}
