#include <LEDA/graphwin.h>
#include <LEDA/graph_alg.h>


main()
{
  GraphWin GW("Drawing Planar Graphs Orthogonally (Tamassia)");
  GW.display();

  GW.set_flush(false);

  GW.set_node_shape(rectangle_node);
  GW.set_node_width(18);
  GW.set_node_height(18);

  for(;;)
  {
    GW.message("Create a planar graph and press done.");

    if ( ! GW.edit() ) break;

    graph& G = GW.get_graph();

    if (!PLANAR(G))
    { GW.message("Graph is not planar");
      continue;
     }

    list<edge> bi_edges = Make_Bidirected(G);
    G.make_map();
    G.make_planar_map();

    node_array<int> xpos(G);
    node_array<int> ypos(G);
    edge_array< list<int> > xbends(G);
    edge_array< list<int> > ybends(G);

    ORTHO_EMBEDDING(G, xpos, ypos, xbends, ybends, false);

    edge e;
    forall(e,bi_edges) G.del_edge(e);

    GW.update_edges();

    GW.remove_bends();

    node v;
    forall_nodes(v,G)
       GW.set_position(v,point(xpos[v],ypos[v]));

    forall_edges(e,G)
    { list<int> lx; xbends[e];
      list<int> ly = ybends[e];
      
      list<point> pol;
      while ( !lx.empty() )
      { double x = lx.pop();
        double y = ly.pop();
        pol.append(point(x,y));
       }
      if (!pol.empty()) 
        GW.set_polygon(e,pol);
    }

   GW.fill_window();

  }

  return 0;
}
