\documentstyle{cweb}
\begin{document}

@ Das 

@c

/*{\Manpage {T} {} {Class Example} {x}}*/
class T{

/*{\Mdefinition
   Class T as an T.}*/

public:

/*{\Mcreation}*/

T(const int& i);
/*{\Mcreate 
introduces a variable |\Mvar| of type |\Mname|.}*/


/*{\Moperations 2 4.5 }*/

/*{\Mtext {\bf Creation/Deletion}}*/

void* operator new(int size_t);
/*{\Munop New.}*/


void operator delete(void*);
/*{\Munop Delete.}*/



/*{\Mtext Arithmetic Operators}*/

T operator+(T y);
/*{\Mbinop Addition.}*/

friend T operator+(T x,T y);
/*{\Mbinopfunc Addition as friend.}*/



T operator-(T y);
/*{\Mbinop Subtraction.}*/

friend T operator-(T x,T y);
/*{\Mbinopfunc Subtraction as friend.}*/




T operator*(T y);
/*{\Mbinop Multiplication.}*/

friend T operator*(T x,T y);
/*{\Mbinopfunc Multiplication as friend.}*/



T operator/(T y);
/*{\Mbinop Division.}*/

friend T operator/(T x,T y);
/*{\Mbinopfunc Division as friend.}*/


T operator^(T y);
/*{\Mbinop Bitwise exclusive OR.}*/

friend T operator^(T x,T y);
/*{\Mbinopfunc Bitwise exclusive OR as friend.}*/


T operator%(T y);
/*{\Mbinop MOD.}*/

friend T operator%(T x,T y);
/*{\Mbinopfunc MOD as friend.}*/



T operator+();
/*{\Munop Positive.}*/

friend T operator+(T x);
/*{\Munopfunc Positive as friend.}*/



T operator-();
/*{\Munop Negative.}*/

friend T operator-(T x);
/*{\Munopfunc Negative as friend.}*/



/*{\Mtext {\bf Bitwise Operators}}*/

T operator&(T y);
/*{\Mbinop Bitwise AND.}*/

friend T operator&(T x,T y);
/*{\Mbinopfunc Bitwise AND as friend.}*/



T operator|(T y);
/*{\Mbinop Bitwise OR.}*/

friend T operator|(T x,T y);
/*{\Mbinopfunc Bitwise OR as friend.}*/

	
T operator~();
/*{\Munop Bitwise Complement.}*/

friend T operator~(T x);
/*{\Munopfunc Bitwise Complement as friend.}*/



/*{\Mtext {\bf Boolean Operators}}*/

T operator!();
/*{\Munop NOT.}*/

friend T operator!(T x);
/*{\Munopfunc NOT as friend.}*/



bool  operator&&(T y);
/*{\Mbinop AND.}*/

friend bool operator&&(T x,T y);
/*{\Mbinopfunc AND as friend.}*/



bool  operator||(T y);
/*{\Mbinop OR.}*/

friend bool operator||(T x,T y);
/*{\Mbinopfunc OR as friend.}*/





/*{\Mtext
{\bf Assignment Operators}
}*/

T operator=(T y);
/*{\Mbinop Assignment.}*/



T&  operator+=(T y);
/*{\Mbinop Add and assign.}*/

friend T operator+=(T x,T y);
/*{\Mbinopfunc Add and assign as friend.}*/



T  operator%=(T y);
/*{\Mbinop modulo and assign.}*/

friend T operator%=(T x,T y);
/*{\Mbinopfunc modulo and assign as friend.}*/



T&  operator^=(T y);
/*{\Mbinop exclusive OR and assign.}*/

friend T operator^=(T x,T y);
/*{\Mbinopfunc exclusive OR and assign as friend.}*/



T&  operator-=(T y);
/*{\Mbinop Substract and assign.}*/

friend T&  operator-=(T x,T y);
/*{\Mbinopfunc Substract and assign as friend.}*/



T&  operator|=(T y);
/*{\Mbinop OR and assign.}*/

friend T&  operator|=(T x,T y);
/*{\Mbinopfunc OR and assign as friend.}*/



T&  operator>>=(int k);
/*{\Mbinop Shift right and assign.}*/

friend T&  operator>>=(T x,T y);
/*{\Mbinopfunc Shift right and assign as friend.}*/



T&  operator<<=(int k);
/*{\Mbinop Shift left and assign.}*/

friend T&  operator<<=(T x,T y);
/*{\Mbinopfunc Shift left and assign as friend.}*/



T&  operator*=(T y);
/*{\Mbinop Multiply and assign.}*/

friend T&  operator*=(T x,T y);
/*{\Mbinopfunc Multiply and assign as friend.}*/




T&  operator/=(T y);
/*{\Mbinop Divide and assign.}*/

friend T&  operator/=(T x,T y);
/*{\Mbinopfunc Divide and assign as friend.}*/



T&  operator&=(T y);
/*{\Mbinop And and assign.}*/

friend T&  operator&=(T x,T y);
/*{\Mbinopfunc And and assign as friend.}*/



/*{\Mtext
{\bf Array and Function Call Operator}
}*/
T& operator[](int i);
/*{\Marrop returns a reference to the contents of i.}*/

T operator()(int i);
/*{\Mfunop returns the T at position i.}*/

/*{\Mtext I/O-Operators}*/

friend ostream& operator<<(ostream& O, const T& e);
/*{\Mbinopfunc     writes T |e| to the output stream |O|. }*/

friend istream& operator>>(istream& I, T& e);
/*{\Mbinopfunc    reads |e| from input stream |I|.}*/

/*{\Mtext Comparison Operators}*/

bool  operator<=(T y);
/*{\Mbinop Lower Equal.}*/

friend bool operator<=(T x,T y);
/*{\Mbinopfunc Lower Equal as friend.}*/



bool  operator>=(T y);
/*{\Mbinop Greater Equal.}*/

friend bool operator>=(T x,T y);
/*{\Mbinopfunc Greater Equal as friend.}*/



bool  operator<(T y);
/*{\Mbinop Lower.}*/

friend bool operator<(T x,T y);
/*{\Mbinopfunc Lower as friend.}*/




bool  operator>(T y);
/*{\Mbinop Greater.}*/

friend bool operator>(T x,T y);
/*{\Mbinopfunc Greater as friend.}*/



bool  operator!=(T y);
/*{\Mbinop Inequality.}*/

friend bool operator!=(T x,T y);
/*{\Mbinopfunc Inequality as friend.}*/



bool  operator==(T y);
/*{\Mbinop Equality.}*/

friend bool operator==(T x,T y);
/*{\Mbinopfunc Equality as friend.}*/




/*{\Mtext {\bf Increment and Decrement}}*/

T operator++();
/*{\Munop Increment Prefix.}*/

friend T operator++(T x);
/*{\Munopfunc  Increment Prefix as friend function.}*/



T operator++(int);
/*{\Munop Increment Suffix.}*/

friend T operator++(T x,int);
/*{\Munopfunc  Increment Suffix as friend function.}*/



T operator--();
/*{\Munop Decrement Prefix.}*/

friend T operator--(T x);
/*{\Munopfunc  Decrement Prefix as friend function.}*/



T operator--(int);
/*{\Munop Decrement Suffix.}*/

friend T operator--(T x,int);
/*{\Munopfunc  Decrement Suffix as friend function.}*/



/*{\Mtext {\bf Adressing}}*/

T operator*();
/*{\Munop Dereference.}*/

friend T operator*(T x);
/*{\Munopfunc Dereference as friend.}*/



T operator&();
/*{\Munop Address.}*/

friend T operator&(T x);
/*{\Munopfunc Address  as friend.}*/



T operator->();
/*{\Munop Pointer to. Also called dereference. DAs ist Suffix}*/



T* operator->*(int y);
/*{\Mbinop Pointer to member.}*/

friend T operator->*(T x,int y);
/*{\Mbinopfunc Pointer to member as friend.}*/



/*{\Mtext {\bf Sonstiges}}*/

void operator,(int y);
/*{\Mbinop Tuple.}*/

friend T operator,(T x,int y);
/*{\Mbinopfunc Tuple as friend.}*/



};

/*{\Mimplementation 
bla bla}*/

@
\end{document}
