#include <math.h>
#include <LEDA/plane_alg.h>


#define TEST_ALG(name,ALG,seglist,G) {\
cout << string("%s  k = %2d  ",name,k) << flush;\
float T = used_time();\
ALG(seglist,G);\
float t = used_time(T);\
cout << string("|V|= %4d ",G.number_of_nodes());\
cout << string("|E|= %4d ",G.number_of_edges());\
cout << string("time = %6.2f sec  ",t);\
newline; }


main()
{ 
  int N  = read_int("N  = ");
  int k  = read_int("k  = ");
  int l  = 0;

  rand_int.set_seed(1234567*N);

  for (; k <= 300; k+=10)
  {
    integer size = 1;

    size <<= (k-1);

    list<rat_segment> seglist;
    list<segment> seglist1;

    GRAPH<rat_point,rat_segment> G;
    GRAPH<point,segment> G1;

    for(int i=0; i < N; i++)
    { integer x1 = integer::random(k)-size;
      integer y1 = integer::random(k)-size;
    //integer w1 = integer::random(l);
      integer w1 = 1;
      integer x2 = integer::random(k)-size;
      integer y2 = integer::random(k)-size;
    //integer w2 = integer::random(l);
      integer w2 = 1;
      rat_segment s(rat_point(x1,y1,w1),rat_point(x2,y2,w2));
      seglist.append(s);
      segment s1(x1.todouble(),y1.todouble(),x2.todouble(),y2.todouble());
      seglist1.append(s1);
     }
  

   TEST_ALG("SWEEP(rat)     ",SWEEP_SEGMENTS,seglist,G)
   TEST_ALG("MULMULEY(rat)  ",MULMULEY_SEGMENTS,seglist,G)
   newline;
   TEST_ALG("SWEEP(float)   ",SWEEP_SEGMENTS,seglist1,G1)
   TEST_ALG("MULMULEY(float)",MULMULEY_SEGMENTS,seglist1,G1)
   newline;

   }
  
  return 0;
}

