/*******************************************************************************
+
+  LEDA 3.5
+
+  local.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef _GW_LOCAL_H_
#define _GW_LOCAL_H_

/****************************************************************************/
/*               Default values set at startup                              */
/****************************************************************************/
   
#define DefXMin		0
#define DefXMax		100
#define DefYMin		0

#define DefBgColor              white
#define DefNodePos		point(0,0)
#define DefNodeColor		yellow
#define DefEdgeColor		black
#define DefEdgeWidth		1
#define DefNodeShape		circle_node
#define DefNodeBorderColor 	black
#define DefEdgeStyle		solid_edge
#define DefNodeEmbed		random_embed
#define DefEdgeDist 		5
#define DefAutoCreateTarget     true
#define DefFlush		true
#define DefDirected		false
#define DefGridDist		0
#define DefShowStatus		true
#define DefShowMask             (STAT_NODES|STAT_EDGES|STAT_COORD)
#define DefZoomFactor		1.4
#define DefAnimationSteps 	16
#define DefAnimationMode  	move_all_nodes
#define DefNodeWidth		20
#define DefNodeHeight		20
#define DefConstWidth		true
#define DefNodeLabelPos		central_pos
#define DefEdgeLabelPos		east_pos
#define DefGenNodes		16
#define DefGenEdges		30
#define DefEdgeLabel		""
#define DefNodeLabel		""
#define DefNodeLabelClr		-1
#define DefEdgeLabelClr 	black
#define DefNodeMarked		false
#define DefEdgeMarked		false
#define DefAutoEdge		true
#define DefCallsEnabled		true
#define DefOrthoMode            false;
#define DefNodeLabelType  	index_label
#define DefEdgeLabelType  	user_label
#define DefButtonsPerLine	6
#define DefExtraButtonsPerLine	4
#define DefDoneResult		-1
#define DefGWFileName		"graph.gw"
#define DefPSFileName		"graph.ps"
#define DefMaxMoveItems 	50
#define DefWinSizeX		560
#define DefWinSizeY		600



/****************************************************************************/
/*                                                                          */
/****************************************************************************/
   
#define NEW_BUTTON	MOUSE_BUTTON(1)
#define INFO_BUTTON	MOUSE_BUTTON(2)
#define DEL_BUTTON	MOUSE_BUTTON(3)

// GraphWin-created objects (window, graph, etc.)  

#define cr_none		(0l)
#define cr_stuff	(1l << 1)
#define cr_win		(1l << 2)
#define cr_graph	(1l << 3)

/****************************************************************************/
/*                                                                          */
/****************************************************************************/
   
enum { exit_pressed=0 , done_pressed=1 };

extern void gw_reduce_polygon(list<point>& P);


#endif /* _GW_LOCAL_H_ */
