/*******************************************************************************
+
+  LEDA 3.5
+
+  sweep.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_SWEEP_H
#define LEDA_SWEEP_H

#include <LEDA/sortseq.h>

template <class K, class I, class pos_type>

class sweep_line : public sortseq<K,I>
{
  pos_type  sw_pos;

  int cmp(GenPtr x, GenPtr y) const
  { return compare(sw_pos,LEDA_ACCESS(K,x),LEDA_ACCESS(K,y)); }
  
public:

  pos_type  get_position() { return sw_pos; }

  pos_type  set_position(const pos_type& new_pos) 
  { pos_type old_pos = sw_pos; sw_pos = new_pos; return old_pos; }

  pos_type  move_to(const pos_type& new_pos) { return set_position(new_pos); }

  sweep_line() {}
  sweep_line(const pos_type p) : sw_pos(p) {}
 ~sweep_line() {}

};

#endif
