/*******************************************************************************
+
+  LEDA 3.5
+
+  misc.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/

#ifndef LEDA_MISC_H
#define LEDA_MISC_H

#if !defined(LEDA_ROOT_INCL_ID)
#define LEDA_ROOT_INCL_ID 350076
#include <LEDA/REDEFINE_NAMES.h>
#endif

#include <LEDA/basic.h>

class string;


/*{\Manpage {misc} {} {Some Useful Functions}  }*/

/*{\Mtext
The following functions and macros are defined in \<LEDA/basic.h\>.
}*/

/*{\Moptions nextwarning=no}*/
int read_int();
int read_int(string s);
/*{\Mfunc  prints $s$ and reads an integer from $cin$.}*/

/*{\Moptions nextwarning=no}*/
double read_real();
double read_real(string s);
/*{\Mfunc  prints $s$ and reads a real number from $cin$.}*/


void skip_line(istream& =cin);
string read_line(istream& =cin);

/*{\Moptions nextwarning=no}*/
string read_string();
string read_string(string s);
/*{\Mfunc  prints $s$ and reads a line from $cin$.}*/

/*{\Moptions nextwarning=no}*/
char read_char();
char read_char(string s);
/*{\Mfunc  prints $s$ and reads a character from $cin$.}*/



/*{\Moptions nextwarning=no}*/
int Yes();
int Yes(string s);
/*{\Mfunc  returns (read\_char($s$) == `y').}*/

float used_time();
/*{\Mfunc  returns the currently used cpu time in seconds.}*/

float used_time(float& T);
/*{\Mfunc  returns the cpu time used by the program from time
           $T$ up to this moment and assigns the current
           time to $T$.}*/

void print_time(string s);
void print_time();

void wait(float sec);  
/*{\Mfunc suspends execution for $sec$ seconds.}*/




/*{\Moptions nextwarning=no}*/
/*
void  print_statistics();
*/

/*{\Mfunc prints a summary of the currently used memory. }*/



// maximal and minimal values for some numerical types

inline int    Max_Value(int& x)     { return x =  MAXINT;   }
inline int    Min_Value(int& x)     { return x = -MAXINT;   }
inline float  Max_Value(float& x)   { return x =  MAXFLOAT; }
inline float  Min_Value(float& x)   { return x = -MAXFLOAT; }
inline double Max_Value(double& x)  { return x =  MAXDOUBLE;}
inline double Min_Value(double& x)  { return x = -MAXDOUBLE;}


template <class T> 
inline T Max(const T& a, const T& b) 
{ return (a>b) ? a : b; }
/*{\Mfunc     returns the maximum of $a$ and $b$. }*/

template <class T> 
inline T Min(const T& a, const T& b) { return (a<b) ? a : b; }
/*{\Mfunc     returns the minimum of $a$ and $b$. }*/

template <class T> 
inline void leda_swap(T& a, T& b) { T tmp = a; a = b; b = tmp; }
/*{\Mfunc   swaps values of $a$ and $b$. }*/


#define newline  cout << endl


#if LEDA_ROOT_INCL_ID == 350076
#undef LEDA_ROOT_INCL_ID
#include <LEDA/UNDEFINE_NAMES.h>
#endif

#endif
