/*******************************************************************************
+
+  LEDA 3.5
+
+  x_basic.h
+
+  This file is part of the LEDA research version (LEDA-R) that can be 
+  used free of charge in academic research and teaching. Any commercial
+  use of this software requires a license which is distributed by the
+  LEDA Software GmbH, Postfach 151101, 66041 Saarbruecken, FRG
+  (fax +49 681 31104).
+
+  Copyright (c) 1991-1997  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 66123 Saarbruecken, Germany     
+  All rights reserved.
+ 
*******************************************************************************/
#ifndef LEDA_X_BASIC_H
#define LEDA_X_BASIC_H


// basic graphics operations used in the LEDA window & panel classes

#include <LEDA/impl/x_window.h>


// display

void x_open_display(void);
void x_close_display(void);
void x_flush_display(void);
int  x_display_width(void);
int  x_display_height(void);
int  x_display_depth(void);
int  x_display_bits_saved();


// windows

int x_create_window(void* inf, int width,int height, int bg_col, 
                    const char* header, const char* label, int parent,
                    void (*f)(void*));

void x_open_window(int win, int x, int y, int w, int h, int p_win=0);
void x_resize_window(int win, int width, int height);
void x_clear_window(int win);
void x_close_window(int win);
void x_destroy_window(int win);

void x_set_clip_rect(int win, int x0, int y0, int w, int h);


int   x_window_opened(int win);

void* x_window_inf(int win);
int   x_window_height(int win);
int   x_window_width(int win);
void  x_window_position(int win, int* x, int* y);

void x_set_header(int win, const char *s);
void x_set_border_width(int win, int w);

void x_set_icon_pixmap(int win,char*);

int  x_create_buffer(int);
int  x_create_buffer(int,int,int);
void x_delete_buffer(int);
void x_flush_buffer(int,int,int,int,int);
void x_flush_buffer(int,int,int,int,int,int,int);
void x_start_buffering(int);
void x_start_buffering(int,int,int);
void x_stop_buffering(int);
int  x_test_buffer(int);

void x_start_timer(int win, int msec);
void x_stop_timer(int win);


// drawing

void x_pixel(int win, int x, int y);
int  x_get_pixel(int win, int x, int y);
void x_pixels(int win, int n, int* x, int* y);

void x_point(int win, int x, int y);
void x_line(int win, int x1, int y1, int x2, int y2);
void x_lines(int win, int n, int* x1, int* y1, int* x2, int* y2);
void x_rect(int win, int x1, int y1, int x2, int y2);
void x_box(int win, int x1, int y1, int x2, int y2);
void x_polygon(int win, int n, int* xcoord, int* ycoord);
void x_arc(int win,int x0,int y0,int r1,int r2,double start,double angle);
void x_circle(int win, int x0, int y0, int r);
void x_ellipse(int win, int x0, int y0, int r1, int r2);
void x_fill_polygon(int win, int n, int* xcoord, int* ycoord);
void x_fill_arc(int win,int x0,int y0,int r1,int r2,double start,double angle);
void x_fill_circle(int win, int x0, int y0, int r);
void x_fill_ellipse(int win, int x0, int y0, int r1, int r2);

void x_text(int win, int x, int y, const char* s);
void x_text(int win, int x, int y, const char* s, int l);
void x_ctext(int win, int x, int y, const char* s);


// bitmaps

char* x_create_bitmap(int win, int width, int height, char* data);
void  x_insert_bitmap(int win, int x, int y, char* bmap);
void  x_delete_bitmap(char* bmap);


// pixrects

char* x_create_pixrect(int win, int w, int h, char* data, int fg, int bg);
char* x_create_pixrect(int win, int x1, int y1, int x2, int y2);
char* x_create_pixrect(int win, char** xpm);
char* x_get_buffer_pixrect(int win);
void  x_insert_pixrect(int win, int x, int y, char* prect);
void  x_insert_pixrect(int win, int x, int y, char*,int,int,int,int);
void  x_insert_pixrect(int win, char* prect);
void  x_delete_pixrect(char* prect);
void  x_copy_pixrect(int win, int x1, int y1, int x2, int y2, int x, int y);

void  x_pixrect_dimensions(char*,int*,int*);


// fonts and text

int  x_load_text_font(const char* font_name);
int  x_load_bold_font(const char* font_name);
int  x_load_fixed_font(const char* font_name);

void x_set_text_font(int win);
void x_set_bold_font(int win);
void x_set_fixed_font(int win);

int x_set_font(int win, const char* fname);

int x_text_width(int win, const char* s);
int x_text_width(int win, const char* s, int l);
int x_text_height(int win, const char* s);


// drawing parameters

int           x_set_color(int win, int col);
int           x_set_line_width(int win, int w);
int           x_set_join_style(int win, int s);
drawing_mode  x_set_mode(int win, drawing_mode m);
text_mode     x_set_text_mode(int win, text_mode tm);
line_style    x_set_line_style(int win, line_style ls);

int           x_get_color(int win);
int           x_get_line_width(int win);
drawing_mode  x_get_mode(int win);
text_mode     x_get_text_mode(int win);
line_style    x_get_line_style(int win);


void x_set_read_gc(int win);
void x_reset_gc(int win);


// colors

int  x_new_color(const char*);
int  x_new_color(int,int,int);
void x_set_palette(int,int,int,int);
void x_get_palette(int,int*,int*,int*);


// events

int x_get_next_event(int* win, int* val, int* x, int* y, unsigned long *t);
int x_get_next_event(int *w, int *val, int *x, int *y, unsigned long *t, int usec);
int x_check_next_event(int* win, int* val, int* x, int* y, unsigned long *t);
void x_put_back_event(void);


// mouse

void x_grab_pointer(int w);
void x_ungrab_pointer();
//void x_move_pointer(int win, int x, int y);



//misc

void x_window_to_screen(int w, int* x, int* y);
void x_screen_to_window(int w, int* x, int* y);



#endif
