#include <LEDA/window.h>
#include <time.h>
#include <math.h>

const char* month[] =
{ "Januar",
  "Februar",
  "Maerz",
  "April",
  "Mai",
  "Juni",
  "Juli",
  "August",
  "September",
  "Oktober",
  "November",
  "Dezember"
 };


void display_date(window* wp)
{ time_t clock; 
  time(&clock);
  tm* T = localtime(&clock); 
  string date("%d. %s 19%0d",T->tm_mday,month[T->tm_mon], T->tm_year%100);
  wp->set_frame_label(date);
 }


void display_time(window* wp)
{ time_t clock; 
  time(&clock);
  tm* T = localtime(&clock); 
  int s = T->tm_sec;
  int m = T->tm_min;
  int h = T->tm_hour;
  double x = (wp->xmax() - wp->xmin())/2;
  double y = (wp->ymax() - wp->ymin())/2;
  wp->set_mode(src_mode);
  wp->clear(grey1);
  wp->draw_ctext(x,y,string("%02d:%02d:%02d",h,m,s), blue2);
  if (h+m == 0) display_date(wp);
}


main()
{
  window W(180,50);

  W.display();
  W.set_redraw(display_time);

#if defined(unix)
  W.set_font("lucidasans-bold-24");
#else
  W.set_font("B3");
#endif

  display_time(&W);
  display_date(&W);

  W.start_timer(990,display_time);

  W.read_mouse();

  return 0;
}
