#include <LEDA/graphwin.h>
#include <LEDA/graph_alg.h>


void highlight(GraphWin& GW, list<node> V, list<edge> E, node_array<int>& kind) {
  node v;
  edge e;

  forall(v,V) 
    switch (kind[v]) {
        
      case  2: GW.set_color(v,black);
               GW.set_label_type(v,no_label);
               GW.set_width(v,2);
               break;

      case  4:
      case  3: GW.set_shape(v,rectangle_node);
               GW.set_color(v,red);
               break;

      case -3: GW.set_shape(v,rectangle_node);
               GW.set_color(v,blue2);
               break;
    }

    const graph& G = GW.get_graph();

    forall_edges(e,G) GW.set_style(e,dotted_edge);
        
    forall(e,E) {
      GW.set_style(e,solid_edge);
      GW.set_color(e,black);
      GW.set_width(e,2);
    }
}



main() {

panel P("LEDA Planarity Test Demo");
P.text_item("This demo illustrates planarity testing and straight-line");
P.text_item("embedding using the LEDA GraphWin data type. You can generate a");
P.text_item("graph either interactively by simply drawing it into the window");
P.text_item("or by using one of the graph generators from the menu. The graph");
P.text_item("is displayed and (after clicking the continue button tested for");
P.text_item("planarity. If it is planar a straight-line planar drawing is");
P.text_item("produced, otherwise, a Kuratowski subdivison is shown.");
P.button("continue");
P.open();


  graph G;

  GraphWin GW(G);

  GW.display();

  while (GW.edit()) {

    list<node> loop_nodes(Delete_Loops(G));
    list<edge> parallel_edges(Make_Simple(G));

    if ( (!loop_nodes.empty()) || (!parallel_edges.empty()) ) {
      GW.set_flush(true);
      GW.update_edges();
    }

/*
    edge e;
    forall_edges(e,G)
      if (G.source(e) == G.target(e))
      { GW.message("Graph contains loops ...");
        continue;
      }
     
    if (!Is_Simple(G))
    { GW.message("Graph is not simple ...");
      continue;
     }
*/

    GW.set_flush(false);

    if (PLANAR(G)) { 
        list<edge> dummy_edges;
        Make_Biconnected(G,dummy_edges);
        Make_Bidirected(G,dummy_edges);
        node_array<double> xcoord(G);
        node_array<double> ycoord(G);
        PLANAR(G,true);
        STRAIGHT_LINE_EMBEDDING(G,xcoord,ycoord);

        node v;
        forall_nodes(v,G) {  
           xcoord[v] = 5 +  90*xcoord[v];
           ycoord[v] = 5 + 140*ycoord[v];
         }

        edge e;
        forall(e,dummy_edges) G.del_edge(e);
        
        GW.set_flush(true);
        GW.set_position(xcoord,ycoord);
      
    }
    else 
      { GW.message("Graph is not planar. Computing a Kuratowski subdvision ...");
        list<node> V;
        list<edge> E;
        node_array<int> kind(G);
  
        KURATOWSKI(G,V,E,kind);

        highlight(GW,V,E,kind);
        GW.redraw();

        GW.wait("Click done button");  
        GW.reset();
        GW.redraw();
      }

  }

  return 0;
}
