/* udata.h */

#ifndef UDATA__H
#define UDATA__H

#include "units.h"
#include "data.h"

/* dc_udata is the base for data classes that have units associated with them */
class dc_udata : public dc_data {
protected:
  unit_vec units; /* integer string of powers of base unit types. see units.h */
  
public:
  void get_xtype( xtype &xt ); /* source in data.cc */

  /* defined as virtual in dc_data */
  const bool has_units( void ) const { return true; }

  void set_units( const unit_vec &V ) { units = V; }
  unit_vec &get_units( void ) { return units; }
  const unit_vec &get_units_c( void ) const { return units; }
};

/* if d is unitless and lbl matches a default value with units then
   d is given that default value's units. returns true if a change is made
   ex. ( dc_real( 3 ), "mass" ) -> 3 kg if a default mass with units kg exists.
   */
bool set_default_units( dc_udata &d, cstring lbl, dc_node *origin );

#endif
