/* triple.h */

#ifndef TRIPLE__H
#define TRIPLE__H

#include "vector.h"

class dc_triple : public dc_matrix {
protected:
  ColumnVector val;
public: 
  dc_triple( const double x = 0, const double y = 0, const double z = 0 );
  dc_triple( const double x, const double y, const double z, 
	     const string &label, dc_node *parent = nil );
  dc_triple( const ColumnVector &V, const string &label = "", 
	     dc_node *parent = nil );
  dc_triple( const string &label, dc_node *parent = nil );
  
  /* inherited functions */
  const dc_type sub_type( void ) const { return Triple_t; }
  string type_string( void ) const { return valid ? string( "triple" ) :
                                            string( "invalid triple" ); }
  
  /* input, output, and assignment operators */
  dc_triple &operator=( const ColumnVector &V );
  dc_triple &operator=( const RowVector &V );
  dc_triple &operator=( dc_data &D );

  ostream &display( ostream &stream = cout ){ return display_c( stream ); }
  ostream &display_c( ostream &stream = cout ) const;
  friend ostream &operator<<( ostream &stream, const dc_triple &T ) {
    return T.display_c( stream );
  }
  friend istream &operator>>( istream &stream, dc_triple &T );

  /* indexing start at 1 */
  Real operator()( const int i ) const { return val( i ); }

  /* functions to access Col/Row */
  ReturnMatrix get( void );
  ReturnMatrix get_as_col( void ) { return get(); }
  ReturnMatrix get_as_row( void );
  void set( const ColumnVector &V );
  void set_row( const RowVector &V );
  void set( dc_triple &T );
  void set( double d[3] );
  void resize( const int ) 
    { dc_trace( TRACE_ERROR ) 
	cerr << "triple::resize -- triples cannot be resized\n"; }
  /* included for compatability with dc_vector */
  int dim( void ) const { return 3; }
  int Nrows( void ) const { return 3; }
  int Ncols( void ) const { return 1; }

  /* returns location of vectors array.  do not delete */
  Real *get_store( void ) const { return val.Store(); }
  int get_storage( void ) const { return 3; }

  dc_label *duplicate( dc_node *parent ) const;
};

#endif
