/* string.cc */

#include "string.h"

dc_string::dc_string( cstring s, cstring label, dc_node *parent ) {
  set_both( label, parent );
  val = s;
}

ostream &dc_string::display_c( ostream &stream = cout ) const {
  return stream << '\"' << val << '\"';
}

istream &operator>>( istream &stream, dc_string &S ) {
  return stream >> S.val;
}

bool dc_string::operator==( dc_string &s ) {
  return val == s.val;
}

bool dc_string::operator!=( dc_string &s ) {
  return val != s.val;
}

bool dc_string::operator<( dc_string &s ) {
  return val < s.val;
}

bool dc_string::operator>( dc_string &s ) {
  return val > s.val;
}

bool dc_string::operator<=( dc_string &s ) {
  return val <= s.val;
}

bool dc_string::operator>=( dc_string &s ) {
  return val >= s.val;
}

dc_string &dc_string::operator+( dc_string &s ) {
  return *( new dc_string( val + s.val ) );
}

dc_string &dc_string::operator+=( dc_string &s ) {
  val += s.val;
  return *this;
}

void dc_string::set_parsed( cstring S ) {
  val = S;
  int len = S.length();
  for( int i = 0 ; i < len ; i++ ) {
    if( val[i] == '\\' && i < len - 1 ) {
      val.del(i);
      char replacement = 0;
      switch( S[i] ) {
      case 'n' : 
	replacement = '\n'; break;
      case 'r' :
	replacement = '\r'; break;
      case '0' :
	replacement = '\0'; break;
//    case '\\' : case '\"' : case '\'' :
      default: replacement = val[i];
      }
      val[i] = replacement;
      if( ++i >= --len ) break;
    }
  }
}

dc_label *dc_string::duplicate( dc_node *parent ) const {
  dc_string *dupe = new dc_string( val );
  if( !is_temporary() ) {
    if( dupe->set_both( local_label(), parent ) ) {
      delete( dupe );
      return nil;
    }
  }
  dupe->set_visible( is_visible() );
  return ( dc_label * )dupe;
}
