/* signal_change.h */

#ifndef SIGNAL_CHANGE__H
#define SIGNAL_CHANGE__H

#include "id.h"
#include "element.h"

/* the signal_hchange function is called by dc_label memeber functions 
   set_label, set_parent, and set_both whenever a **SUCCESSFUL** change is 
   completed.  since all the constructors of dc_label and its descendent classes
   call these functions, all hierarchy changes will be signalled through these.

   calls to the three member functions that fail due to invalid args or 
   label conflicts in the hierarchy will not signal any change

   parameters : target - address of dc_label being modified
                label_change - true iff target's label has been changed
		old_label - local label before change.  valid iff label_change
		parent_change - true iff target's parent has changed
		old_parent - parent before change. valid iff parent_change
		initialization - true iff target was previously temporary,
		                 meaning it did not appear in hierarchy before.
				 label_change and parent_change will be false
				 on an initialization call. */
void signal_hchange( const dc_label *target, const bool label_change,
		     const string &old_label, const bool parent_change,
		     const dc_label *old_parent, const bool initialization );

/* signals death of a non-temporary label.  all target's descendents will also 
   be deleted, but signal_death is only called once */
void signal_death( const tag T, const string &label, const dc_label *parent );

/* called when label's visibility changes.  note: change may be to invisible
   so check target->is_visible() */
void signal_visible( const dc_label *target );

/* called once when root opens by roots constructor */
void signal_root_open( void );

/* called after every root reset.  reset occurs on call to clear which deletes
   entire hierarchy.  signal_root_reset will be preceded by one signal_death
   for every child of root */
void signal_root_reset( void );

/* called by roots destructor on exit since root cannot be explicitly killed */
void signal_root_death( void );

void signal_root_rehash( void ); /* not used yet */

/* called when an elemnet update succeds in changing value. elements with no
   evaluation function or with args without default values will not vall this
   function. */
void signal_update( const dc_element *target );

/* called when an elements that has an evaluation function, and all of whose 
   args have default values recieves a nil value on an update call */
void signal_update_error( const dc_element *target );

/* called when a constraints status changes.  status is new status */
void signal_constraint_flagged( const dc_element *target, const bool status );

/* called if constraint fails to evaluate or returns a non-boolean type */
void signal_constraint_error( const dc_element *target );

/* called when dormant/frozen status( see timed.h ) changeds */
void signal_status_change( const dc_label *target, const dc_status old_status );

#endif
