/* signal_change.cxx */

#include "signal_change.h"

//#define SIG_TEST

#ifdef SIG_TEST
#include <iostream.h>
#endif

#ifdef SIG_TEST
void signal_hchange( const dc_label *t, const bool l, const string &ol,
		     const bool p, const dc_label *op, const bool init ) { 
  cerr << "SIGNAL_HCHANGE TARGET " << t->full_type() << "\n";
  if( l ) cerr << "\tlabel changed from " << ol << "\n";
  if( p ) cerr << "\tparent changed from " 
	       << ( op ? op->full_type() : string( "root" ) ) << "\n";
  if( init ) cerr << "\tinitialized\n";
}
#else
void signal_hchange( const dc_label *, const bool, const string &,
		     const bool, const dc_label *, const bool ) { ; }
#endif

#ifdef SIG_TEST
void signal_death( const tag T, const string &ol, const dc_label *op ) { 
  cerr << "SIGNAL DEATH of tag " << T << ", old_label was " << ol 
       << " and old parent was " 
       << ( op ? op->full_type() : string( "root" ) ) << "\n";
}
#else
void signal_death( const tag, const string &, const dc_label * ) { ; }
#endif

#ifdef SIG_TEST
void signal_visible( const dc_label *t ) { 
  cerr << "SIGNAL_VISIBLE of " << t->full_type() << " changed\n"; 
}
#else
void signal_visible( const dc_label * ) { ; }
#endif

#ifdef SIG_TEST
void signal_root_open( void ) { cerr << "SIGNAL_ROOT_OPEN\n"; }
void signal_root_reset( void ) { cerr << "SIGNAL_ROOT_RESET\n"; }
void signal_root_death( void ) { cerr << "SIGNAL_ROOT_DEATH\n"; }
void signal_root_rehash( void ) { cerr << "SIGNAL_ROOT_REHASH\n"; }
#else
void signal_root_open( void ) { ; }
void signal_root_reset( void ) { ; }
void signal_root_death( void ) { ; }
void signal_root_rehash( void ) { ; }
#endif

#ifdef SIG_TEST
void signal_update( const dc_element *t ) {
  cerr << "SIGNAL_UPDATE of " << t->full_type() << "\n"; }
#else
void signal_update( const dc_element * ) { ; }
#endif

#ifdef SIG_TEST
void signal_update_error( const dc_element *t ) { 
  cerr << "SIGNAL_UPDATE_ERROR of " << t->full_type() << "\n"; }
#else
  void signal_update_error( const dc_element * ) { ; }
#endif

#ifdef SIG_TEST
void signal_constraint_flagged( const dc_element *t, const bool b ) { 
  cerr << "SIGNAL_CONSTRAINT_FLAGGED of " << t->full_type() 
       << " to " << b << "\n"; }  
#else
void signal_constraint_flagged( const dc_element *, const bool ) { ; }
#endif

#ifdef SIG_TEST
void signal_constraint_error( const dc_element *t ) { 
  cerr << "SIGNAL_CONSTRAINT_FLAGGED of " << t->full_type() << "\n"; }
#else
  void signal_constraint_error( const dc_element * ) { ; }
#endif

#ifdef SIG_TEST
void signal_status_change( const dc_label *target, const dc_status old_status ){
  cerr << "SIGNAL_STATUS_CHANGE of " << target->full_type() << " changed from " 
       << dc_status_string[old_status] << "\n";
}
#else
void signal_status_change( const dc_label *, const dc_status ) { ; }
#endif

#ifdef SIG_TEST
#undef SIG_TEST
#endif
