/* preparser.h */

#ifndef PREPARSER__H
#define PREPARSER__H

#include "parser.h"
#include "ga_optimizer.h"

dc_component *preparse_component( token_queue &, dc_component *parent );
bool preparse_cstatus( token_queue &, bool &, bool & );
dc_element *preparse_element( token_queue &, dc_component *parent );
bool preparse_modify( token_queue &, dc_node *parent );
bool preparse_link( token_queue & );
dc_clock *preparse_clock( token_queue &, dc_component *parent );
ga *preparse_ga( token_queue &, dc_node *parent );
bool preparse_block( token_queue &, dc_component *parent );
bool preparse_arg( token_queue &, dc_label *owner );
bool preparse_unit_cast( token_queue & );
bool preparse_func( token_queue &, dc_label *owner );
bool preparse_fcall( token_queue &, dc_label *owner );
bool preparse_iter_loop( token_queue &, dc_label *owner );
bool preparse_f_list( token_queue &, dc_label *owner );
bool preparse_global_def( token_queue &, dc_component *owner );
bool preparse_default( token_queue &, dc_node *parent );
bool preparse_utypes( token_queue & );
bool preparse_enum_def( token_queue & );
bool preparse_symbol_def( token_queue & );
bool preparse_finite_set( token_queue & );
bool preparse_set( token_queue & );
bool preparse_data( token_queue & );
int preparse_vrow( token_queue &, int size );
int preparse_vrow( token_queue & );

bool preparse_int( token_queue & );
bool preparse_real( token_queue & );
bool preparse_int( token_queue &, long int & );

bool preparse_vector( token_queue & );
bool preparse_matrix( token_queue & );
bool preparse_triple( token_queue & );
bool preparse_distribution( token_queue & );
bool preparse_function( token_queue &, dc_label *owner, bool first = false );
bool preparse_pointer( token_queue & );

bool preparse_uv( token_queue &, const bool = true );

extern list<dc_modification *> modify_list;

#endif
